
;;;======================================================
;;;   Gift Selection Expert System
;;;
;;;     This programm choose a suitable gift for a person
;;;    
;;;
;;;     CLIPS Version 6.0 Example
;;;
;;;     To execute, merely load, reset and run.
;;;======================================================


(deffacts ini "initial facts"
	(age 19)
	(like music)
	(educated yes))

(defrule cd "cd gift rule"
    (or (agegroup middle) (agegroup old))
    (like music)
   =>
    (assert (gift CD)))
   

(defrule toy "toy gift rule"
   (agegroup child)
   (price expensive)
   =>
   (assert (gift toy)))

(defrule clothes "clothes gift rule"
   (agegroup middle)
   (price expensive)
   =>
   (assert (gift clothes)))
   

(defrule flowers "flowers gift rule"
    (agegroup old)
   (price expensive)
   =>
   (assert (gift flowers)))


(defrule book "book gift rule"
   (or (agegroup middle) (agegroup child))
   (educated yes)
   =>
   (assert (gift book)))

(defrule child "child age rule"
   (age ?x)
      =>
	(if (< ?x 15) then
   (assert (agegroup child))))

(defrule middle "middle age rule"
   (age ?x)
   =>
(if (and (> ?x 14) (< ?x 35)) then
   (assert (agegroup middle))))

(defrule old "old age rule"
   (age ?x)
   =>
(if (> ?x 34) then
   (assert (agegroup old))))

