
//:1. Simple creating, plotting, testing
//:Create an envelope
Env(); // (use default parameters)
//:Create and plot
Env().plot;
//:Create and test
Env().test;
//===========================
//:2. Creating different shapes with parameters:
//:levels, durations,
Env([0, 1, 0.1, 0], [0.1, 2, 0.5]).test.plot;
//:levels, durations, 1 curve, negative
Env([0, 1, 0.1, 0], [0.1, 2, 0.5], -5).test.plot;
//:levels, durations, 1 curve, positive
Env([0, 1, 0.1, 0], [0.1, 2, 0.5], 5).test.plot;
//:levels, durations, curves for each segment
Env([0, 1, 0.1, 0], [0.1, 2, 0.5], [5, -5, 0]).test.plot;
//:3. Shortcuts for custom envelope shapes
Env.perc.test.plot;
//:
Env.sine.test.plot;
//:
Env.triangle.test.plot;
//:
Env.linen.test.plot;
/* Note:
	There are also other shapes such as circle, cutoff.
	Furthrermore one can use names to create custom shapes for each
	segment in Env.linen.
*/
//:3. Envelopes waiting for release
//:Waits for release
Env.asr.test.plot;
//:Waits for release
Env.adsr.test.plot;
//:Using an envelope with release
//create and store a synth
a = { WhiteNoise.ar(0.1) * Env.adsr.kr(2, \gate.kr(1))  }.play;
//: Set gate to 0 to release the envelope
a.set(\gate, 0);
//:Specify duration of release at release time
a = { WhiteNoise.ar(0.1) * Env.adsr.kr(2, \gate.kr(1))  }.play;
//: Set gate to 0 to release the envelope
a.set(\gate, -5);
//:4. Envelopes in other parameters besides amplitude
a = {
	var env;
	env = Env([60, 58, 61, 57, 64, 55, 67].midicps, 2, 5);
	SinOsc.ar(env.kr, 0, 0.1)
}.play;
//:5. Envelopes in Pbind
(
Pbind(
    \note,  Env([0, 12, 6, 13, 0], [1, 5, 2, 10]),
    \dur, 0.1
).play
)
//:6. Triggering envelopes in a synth
a = {
	var env;
	env = Env.perc(0.01, 0.5);
	WhiteNoise.ar(0.1) * env.kr(0, \trig.tr(0));
}.play;
//:
{
	10 do: {
		a.set(\trig, 1);
		0.5.rand.wait;
	}
}.fork
//:
a = {
	var env;
	env = Env.perc(0.01, 0.5);
	WhiteNoise.ar(0.1) * env.kr(0, Impulse.kr(5));
}.play;
//:
a = {
	var env;
	env = Env.perc(0.01, 0.5);
	WhiteNoise.ar(0.1) * env.kr(0, Dust.kr(5));
}.play;