//:Introduction to file dialog
//Select a path from a file dialog and post it
Dialog openPanel: { | path |
	path.postln;
}
//:Select an audio file from disk and load it into a buffer
//Store the bufer in environment variable ~buffer;
//Note: Make sure to select a valid .wav or .aiff file.
Dialog openPanel: { | path |
	~buffer = Buffer.read(Server.default, path);
};
//:Play the buffer.
~buffer.play;  // plays the entire buffer once
//:Find the duration of the buffer
~buffer.numFrames / ~buffer.sampleRate;

//:Play the buffer with PlayBuf
//The synth continues playing after playing the buffer.
{ PlayBuf.ar(1, ~buffer) }.play;
//:Play the buffer with PlayBuf
//Stop the synth when the buffer is finished.
{ PlayBuf.ar(1, 11, doneAction: 2) }.play;
//:Play the buffer with PlayBuf
//Play in reverse
//Note: Replace 11 with ~buffer ...
{ PlayBuf.ar(1, 11, rate: -1, doneAction: 2) }.play;
//:Play the buffer with PlayBuf
//Play in reverse
{ PlayBuf.ar(1, 10, rate: -1, doneAction: 2, loop: 1) * 5 }.play;
//:Play the buffer with PlayBuf
//Play in reverse once only. use starting point
{
	var buf = 20, startPos;
	startPos = BufFrames.kr(buf);
	PlayBuf.ar(1, buf, rate: -1, doneAction: 2, startPos: startPos - 2) * 5
}.play;
//:Play the buffer with PlayBuf
//Play in reverse once only. use starting point
a = { | buf = 10 |
	PlayBuf.ar(1, buf, rate: -1, doneAction: 2, startPos: BufFrames.kr(buf) - 2, loop: 1) * 5
}.play;
//:
a.set(\buf, 61);

//:Play the buffer with PlayBuf
//Play in reverse once only. use starting point
a = { | buf = 10 |
	PlayBuf.ar(1, buf,
		rate: LFNoise0.kr(1).range(-2, 2),
		doneAction: 2, startPos: BufFrames.kr(buf) - 2, loop: 1) * 5
}.play;
//:
r = {
	loop {
		0.5.exprand(2).wait;
		a.set(\buf, 1 rrand: 70)
	}
}.fork;
//:Play the buffer with PlayBuf
//Loop.
//Stop the synth when the buffer is finished.
{ PlayBuf.ar(1, 10, loop: 1, doneAction: 2) * 5 }.play;
