//:simplest starting point
//:Prep 1: test ASR envelope
Env.asr bb(1, curve: 0).test.plot;
// ====== Prep 2: Test ASR with release ======
//: Prep 2a: Start the sound
a = {
	var env, src;
	env = Env.asr(3, 0.1, 3, curve: 0);
	src = SinOsc.ar(400);
	src * env.kr(2, \trig.kr(1));
}.play;
//:release
a.release(3);
//:Step 2: Control frequency
a = {
	var env, src;
	env = Env.asr(3, 0.1, 3, curve: 0);
	src = SinOsc.ar(\freq.kr(400).lag(\freqlag.kr(0.5)));
	src * env.kr(2, \trig.kr(1)) * \amp.kr(1).lag(\amplag.kr(3));
}.play;
//:
a.set(\freq, 1000);
a.set(\freq, 600);
a.set(\freqlag, 0.03);
//:Step 3: 4 Ugens!
a = {
	var env, src;
	src = (1..4).collect({ | i |
		SinOsc.ar(
			("freq" ++ i).asSymbol.kr(400 rrand: 800)
			.lag(("freqlag" ++ i).asSymbol.kr(9)),
			mul:
			("amp" ++ i).asSymbol.kr(0.1)
			.max(0.01).min(0.2).lag(("amplag" ++ i).asSymbol.kr(3)),
		)
	}).mix;
	env = Env.asr(3, 0.1, 3, curve: 0);
	src * env.kr(2, \trig.kr(1)) * \amp.kr(1).lag(\amplag.kr(3));
}.play;
//:
a.set(\freq1, 600);
//:
r = {
	loop {
		a.set(("amp" ++ 1.rrand(4).asString).asSymbol, (0.001 exprand: 0.25));
		(0.5 rrand: 5).wait;
		a.set(("freq" ++ 1.rrand(4).asString).asSymbol, (100 rrand: 500));
	};
}.fork;
//:
