// SuperCollider notes
//========================================

// 2. COUNTER

//Exercise: make a simple counter
// this is one of many ways to do it: using a Pseries pattern

// a Pseries pattern counts from a start stepwise up to number of times (length), arguments are: start, step, length (= number of times)
// asStream creates a stream from the pattern. Streams generate elements (stuff). Patterns are templates for creating Streams = playing objects

p = Pseries(0, 1, 10).asStream;
p.next; //get the next element
// when elements are over, run the p again to create a new stream


// Get the next element many times, for example 10:
(
	var myCounter;
	myCounter = Pseries(0, 1, 10).asStream;
	10 do: {myCounter.next.postln; }
)

//repeating many times a series of limited length.
//Use the Pattern Pn to repeat the series pattern:
//Example for repeating 3 times:
p = Pn( Pseries(0, 1, 3 ), 3);
//:Pn in a loop:
// create a new stream and store it in a stream:
(
var myCounter;
myCounter = Pn( Pseries(1, 1, 3 ), 3).asStream;
// get the next element 10 times
11 do: { myCounter.next.postln; }
)
// When the stream ends it produces nil.

//========================================

